// $Id: CTimeStretchPanel.cpp,v 1.5 2007/02/11 02:20:27 paul Exp $

/*
 * All contents of this source code are copyright 2007 Exp Digital Uk.
 * This file forms part of the example projects for the Infinity API.
 * You may not redistribute either the source code or the compiled binary.
 * The Infinity API is covered by a fair use licence which you should have recieved with this
 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
 */

#include "CTimeStretchPanel.hpp"
#include "CSCalWindow.hpp"
using Exponent::SCal::CSCalWindow;
using Exponent::SCal::CTimeStretchPanel;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CTimeStretchPanel, CControlPanel);

//	===========================================================================
CTimeStretchPanel::CTimeStretchPanel(IControlRoot *root, const long uniqueId, const CRect &area)
                 : CControlPanel(root->getParentWindow(), root, uniqueId, area, NULL)
                 , m_timestretchBpm1EditBox(NULL)
                 , m_timestretchBpm2EditBox(NULL)
                 , m_timestretchOutputValueLabel(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CTimeStretchPanel);

	this->onDrawDrawThePanelBounds(false);

	m_timestretchBpm1EditBox		= new CTextEdit(this,  e_timestretchBpm1EditBox,		  CSCalWindow::CSCALWINDOW_CONTROL1_RECT, "120.00", this);
	m_timestretchBpm2EditBox		= new CTextEdit(this,  e_timestretchBpm2EditBox,		  CSCalWindow::CSCALWINDOW_CONTROL2_RECT, "125.00", this);
	m_timestretchOutputValueLabel   = new CTextLabel(this, CControl::CCONTROL_NO_ID_REQUIRED, CSCalWindow::CSCALWINDOW_OUTPUTBOX_RECT, CString::CSTRING_EMPTY_STRING);

	// Reference
	m_timestretchBpm1EditBox->referenced();
	m_timestretchBpm2EditBox->referenced();
	m_timestretchOutputValueLabel->referenced();

	// Set the format
	m_timestretchBpm1EditBox->setTextFormat(CGraphics::e_centerCenterAlign);
	m_timestretchBpm2EditBox->setTextFormat(CGraphics::e_centerCenterAlign);
	m_timestretchOutputValueLabel->setTextFormat(CGraphics::e_centerCenterAlign);

	m_timestretchBpm1EditBox->setAlignment(CTextEdit::e_center);
	m_timestretchBpm2EditBox->setAlignment(CTextEdit::e_center);

	// Make single click editable
	m_timestretchBpm1EditBox->setSingleClickEditable();
	m_timestretchBpm2EditBox->setSingleClickEditable();

	// Colours
	m_timestretchBpm1EditBox->setColours(		CAlphaColour::CALPHACOLOUR_BLACK, CSCalWindow::CSCALWINDOW_BACKGROUND_COLOUR, CSCalWindow::CSCALWINDOW_TEXT_COLOUR);
	m_timestretchBpm2EditBox->setColours(		CAlphaColour::CALPHACOLOUR_BLACK, CSCalWindow::CSCALWINDOW_BACKGROUND_COLOUR, CSCalWindow::CSCALWINDOW_TEXT_COLOUR);
	m_timestretchOutputValueLabel->setColours(	CAlphaColour::CALPHACOLOUR_BLACK, CAlphaColour::CALPHACOLOUR_WHITE, CSCalWindow::CSCALWINDOW_ANSWER_TEXT_COLOUR);

	// Add controls
	this->addControl(m_timestretchBpm1EditBox);
	this->addControl(m_timestretchBpm2EditBox);
	this->addControl(m_timestretchOutputValueLabel);

	// Compute
	this->computeTimeStretch();
}

//	===========================================================================
CTimeStretchPanel::~CTimeStretchPanel()
{
	EXPONENT_CLASS_DESTRUCTION(CTimeStretchPanel);

	FORGET_COUNTED_OBJECT(m_timestretchBpm1EditBox);
	FORGET_COUNTED_OBJECT(m_timestretchBpm2EditBox);
	FORGET_COUNTED_OBJECT(m_timestretchOutputValueLabel);
}

//	===========================================================================
void CTimeStretchPanel::handleActionEvent(const CActionEvent &event)
{
	switch(event.getControl()->getUniqueId())
	{
		case e_timestretchBpm1EditBox:
		case e_timestretchBpm2EditBox:
			this->computeTimeStretch();
		break;
	}
}

//	===========================================================================
void CTimeStretchPanel::computeTimeStretch()
{
	double bpm1 = CString::toDouble(m_timestretchBpm1EditBox->getString().getString());
	double bpm2 = CString::toDouble(m_timestretchBpm2EditBox->getString().getString());

	if (bpm1 <= 0.0 || bpm1 >= 1000.0)
	{
		CDialog::notifyUser("BPM # 1 range error!\n\n0 < bpm < 1000\n\nBpm must be between 0 and 1000 bpm", "SCal error", true);
		bpm1 = 120.0;
		m_timestretchBpm1EditBox->setText("120.00");
		m_timestretchBpm1EditBox->update();
	}
	else
	{
		CString string;
		string.setStringWithFormat("%0.02f", bpm1);
		m_timestretchBpm1EditBox->setText(string);
		m_timestretchBpm1EditBox->update();
	}
	if (bpm2 <= 0.0 || bpm2 >= 1000.0)
	{
		CDialog::notifyUser("BPM # 2 range error!\n\n0 < bpm < 1000\n\nBpm must be between 0 and 1000 bpm", "SCal error", true);
		bpm2 = 120.0;
		m_timestretchBpm2EditBox->setText("120.00");
		m_timestretchBpm2EditBox->update();
	}
	else
	{
		CString string;
		string.setStringWithFormat("%0.02f", bpm2);
		m_timestretchBpm2EditBox->setText(string);
		m_timestretchBpm2EditBox->update();
	}

	CString output;
	output.setStringWithFormat("%0.02f", CMusicMath::getTimeStretch(bpm1, bpm2));
	m_timestretchOutputValueLabel->setText(output);
	m_timestretchOutputValueLabel->update();
}